//--------------------------------------------------------------//
// Header
//
// Define : Name, Category, Subcategory, Notes, Flags
//--------------------------------------------------------------//
DeclareLightworksEffect( "Shear", "Samples", kNoSubCategory, kNoNotes, kNoFlags );

//--------------------------------------------------------------//
// Inputs
//--------------------------------------------------------------//

// For each 'input' declared here, Lightworks adds a matching input to your effect

DeclareInput( Input );

//--------------------------------------------------------------//
// Define parameters here.
//
// The Lightworks application will automatically generate
// sliders/controls for all parameters which do not start
// with a a leading '_' character
//--------------------------------------------------------------//
DeclareFloatParam( Horizontal, "Horizontal", kNoGroup, kNoFlags, 0, -1, 1 );
DeclareFloatParam( Vertical,   "Vertical",   kNoGroup, kNoFlags, 0, -1, 1 );

//--------------------------------------------------------------
// Pixel Shader
//
// This section defines the code which the GPU will
// execute for every pixel in an output image.
//
// Note that pixels are processed out of order, in parallel
//--------------------------------------------------------------
DeclarePass( ShearX )
{
   // Amend the x position based on the user-specified shear amount
   float2 pos = uv1;
   pos.x += ( pos.y - 0.5 ) * Horizontal;

   return ReadPixel( Input, pos );
}

DeclareEntryPoint( ShearY )
{
   // Amend the x position based on the user-specified shear amount
   float2 pos = uv1;
   pos.y += ( pos.x - 0.5 ) * Vertical;

   return ReadPixel( ShearX, pos );
}
